/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.galaxies;

import java.util.Locale;
import java.util.function.Predicate;
import micdoodle8.mods.galacticraft.annotations.ReplaceWith;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialType;
import micdoodle8.mods.galacticraft.api.galaxies.ICelestial;
import micdoodle8.mods.galacticraft.core.util.TranslateUtil;

public abstract class CelestialObject
implements ICelestial {
    protected final String bodyName;
    private CelestialType type;
    public String ownerId;

    public CelestialObject(CelestialType type, String bodyName) {
        this(bodyName);
        this.type = type;
    }

    public CelestialObject(String bodyName) {
        this.bodyName = bodyName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String getName() {
        return this.bodyName;
    }

    public String getTranslationKey() {
        return this.getCelestialType().getPrefix() + this.bodyName;
    }

    @Deprecated
    @ReplaceWith(value="getCelestialType().getPrefix()")
    public String getTranslationKeyPrefix() {
        return this.getCelestialType().getPrefix();
    }

    public CelestialType getCelestialType() {
        return this.type;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getTranslatedName() {
        return TranslateUtil.getInstance().translate(this.getTranslationKey());
    }

    public static Predicate<CelestialObject> filter(final String modId) {
        return new Predicate<CelestialObject>(){

            @Override
            public boolean test(CelestialObject celestialObject) {
                return celestialObject.getOwnerId().equals(modId);
            }
        };
    }

    public void setType(CelestialType type) {
        this.type = type;
    }

    @Override
    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }
}

