/*
 * Decompiled with CFR 0.152.
 */
package com.eternalsoap.icbmopencomputersaddon.drivers;

import com.eternalsoap.icbmopencomputersaddon.util.ManagedTileEntityEnvironment;
import com.eternalsoap.icbmopencomputersaddon.util.MissileData;
import icbm.classic.api.EnumTier;
import icbm.classic.content.blocks.launcher.base.TileLauncherBase;
import icbm.classic.lib.transform.vector.Pos;
import java.util.HashMap;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;

public class LauncherEnvironment
extends ManagedTileEntityEnvironment<TileLauncherBase>
implements NamedBlock {
    public static final String COMPONENT_NAME = "icbm_missile_launcher";

    public LauncherEnvironment(TileLauncherBase launcherBase) {
        super(launcherBase, COMPONENT_NAME);
    }

    @Callback(doc="function(s:string):boolean -- Method for finding this component when looping through the component list, returns true iff s == \"icbm_missile_launcher\"")
    public Object[] isICBM(Context context, Arguments arguments) {
        return new Object[]{arguments.checkString(0).equals(COMPONENT_NAME)};
    }

    @Callback(doc="function():number -- Get the X & Z coordinate of the target position")
    public Object[] getTargetPos(Context context, Arguments args) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("x", ((TileLauncherBase)this.tileEntity).launchScreen.getTarget().xi());
        map.put("z", ((TileLauncherBase)this.tileEntity).launchScreen.getTarget().zi());
        return new Object[]{map};
    }

    @Callback(doc="function(x: number, z: number) -- Set the X & Z coordinate of the target position")
    public Object[] setTargetPos(Context context, Arguments args) {
        ((TileLauncherBase)this.tileEntity).launchScreen.setTarget(new Pos((double)args.checkInteger(0), (double)((TileLauncherBase)this.tileEntity).launchScreen.getTarget().yi(), (double)args.checkInteger(1)));
        return null;
    }

    @Callback(doc="function(y: number) -- Sets the detonation height for tier 2 & tier 3 launchers, will not work on tier 1 launchers")
    public Object[] setDetonationHeight(Context context, Arguments args) {
        if (((TileLauncherBase)this.tileEntity).getTier() == EnumTier.ONE) {
            throw new IllegalArgumentException("Setting the Detonation-Height is not supported on launchers of tier 1");
        }
        ((TileLauncherBase)this.tileEntity).launchScreen.setTarget(new Pos((double)((TileLauncherBase)this.tileEntity).launchScreen.getTarget().xi(), (double)args.checkInteger(0), (double)((TileLauncherBase)this.tileEntity).launchScreen.getTarget().zi()));
        return null;
    }

    @Callback(doc="function(): number -- Gets the detonation height for tier 2 & tier 3 launchers, will not work on tier 1 launchers")
    public Object[] getDetonationHeight(Context context, Arguments args) {
        if (((TileLauncherBase)this.tileEntity).getTier() == EnumTier.ONE) {
            throw new IllegalArgumentException("Getting the Detonation-Height is not supported on launchers of tier 1");
        }
        return new Object[]{((TileLauncherBase)this.tileEntity).launchScreen.getTarget().yi()};
    }

    @Callback(doc="function(x: number,z: number):boolean -- Launch missile at stored position or by providing the x and z coordinates")
    public Object[] launch(Context context, Arguments args) {
        return this.launchMissile(context, args);
    }

    @Callback(doc="function(x: number,z: number):boolean -- Launch missile towards the x and z coordinates, if no coordinates are specified use the coordinates set by setTargetPos")
    public Object[] launchMissile(Context context, Arguments args) {
        Pos target = ((TileLauncherBase)this.tileEntity).launchScreen.getTarget();
        if (args.isInteger(0)) {
            target = new Pos((double)args.checkInteger(0), (double)args.checkInteger(1));
        }
        short lockHeight = ((TileLauncherBase)this.tileEntity).launchScreen.lockHeight;
        boolean launchMissile = ((TileLauncherBase)this.tileEntity).launchMissile(target, (int)lockHeight);
        return new Object[]{launchMissile};
    }

    @Callback(doc="function():boolean -- Checks whether a missile is loaded inside the launcher")
    public Object[] containsMissile(Context context, Arguments args) {
        return new Object[]{!((TileLauncherBase)this.tileEntity).getMissileStack().func_190926_b()};
    }

    @Callback(doc="function():string -- Gets the type of missile loaded inside the launcher")
    public Object[] getMissile(Context context, Arguments args) {
        if (((TileLauncherBase)this.tileEntity).getMissileStack().func_190926_b()) {
            return new Object[]{null};
        }
        return new Object[]{MissileData.damageToString(((TileLauncherBase)this.tileEntity).getMissileStack().func_77952_i())};
    }

    @Callback(doc="function():number -- Get the maximum of the missile launcher")
    public Object[] getRange(Context context, Arguments args) {
        return new Object[]{((TileLauncherBase)this.tileEntity).getRange()};
    }

    @Callback(doc="function(x: number,z: number):boolean -- Get whether the given position is within range.")
    public Object[] isInRange(Context context, Arguments args) {
        Pos target = new Pos((double)args.checkInteger(0), (double)args.checkInteger(1));
        return new Object[]{((TileLauncherBase)this.tileEntity).isInRange(target)};
    }

    @Callback(doc="function():number -- Get the inaccuracy of the current missile launcher")
    public Object[] getInaccuracy(Context context, Arguments args) {
        int inaccuracy = 30;
        if (((TileLauncherBase)this.tileEntity).supportFrame != null) {
            inaccuracy = ((TileLauncherBase)this.tileEntity).supportFrame.getInaccuracy();
        }
        return new Object[]{inaccuracy};
    }

    @Callback(doc="function():number -- Get the Frequency of the launcher, only works when the tier supports the frequency")
    public Object[] getFrequency(Context context, Arguments args) {
        if (((TileLauncherBase)this.tileEntity).getTier() == EnumTier.ONE || ((TileLauncherBase)this.tileEntity).getTier() == EnumTier.TWO) {
            throw new IllegalArgumentException("Getting the frequency is not supported on launchers of tier 1 and tier 2");
        }
        return new Object[]{((TileLauncherBase)this.tileEntity).launchScreen.getFrequency()};
    }

    @Callback(doc="function(number):boolean -- Set the Frequency of the launcher, only works when the tier supports the frequency")
    public Object[] setFrequency(Context context, Arguments args) {
        if (((TileLauncherBase)this.tileEntity).getTier() == EnumTier.ONE || ((TileLauncherBase)this.tileEntity).getTier() == EnumTier.TWO) {
            throw new IllegalArgumentException("Setting the frequency is not supported on launchers of tier 1 and tier 2");
        }
        ((TileLauncherBase)this.tileEntity).launchScreen.setFrequency(args.checkInteger(0));
        return null;
    }

    @Callback(doc="function():number -- Get the LockHeight of the launcher, only works when the tier supports the LockHeight")
    public Object[] getLockHeight(Context context, Arguments args) {
        if (((TileLauncherBase)this.tileEntity).getTier() == EnumTier.ONE) {
            throw new IllegalArgumentException("Getting the Lock-Height is not supported on launchers of tier 1");
        }
        return new Object[]{((TileLauncherBase)this.tileEntity).launchScreen.lockHeight};
    }

    @Callback(doc="function(number):boolean -- Set the LockHeight of the launcher, only works when the tier supports the LockHeight")
    public Object[] setLockHeight(Context context, Arguments args) {
        if (((TileLauncherBase)this.tileEntity).getTier() == EnumTier.ONE) {
            throw new IllegalArgumentException("Setting the Lock-Height is not supported on launchers of tier 1");
        }
        ((TileLauncherBase)this.tileEntity).launchScreen.lockHeight = (short)args.checkInteger(0);
        return null;
    }

    @Callback(doc="function():number -- Get the tier of the launcher, [1,2,3]")
    public Object[] getTier(Context context, Arguments args) {
        switch (((TileLauncherBase)this.tileEntity).getTier()) {
            case ONE: {
                return new Object[]{1};
            }
            case TWO: {
                return new Object[]{2};
            }
            case THREE: {
                return new Object[]{3};
            }
        }
        return null;
    }

    public String preferredName() {
        return COMPONENT_NAME;
    }

    public int priority() {
        return 1;
    }
}

