/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.entities.ai;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.block.BlockBOPPlant;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAIEatBOPGrass
extends EntityAIEatGrass {
    private static final Predicate<IBlockState> IS_TALL_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_150329_H).func_177637_a((IProperty)BlockTallGrass.field_176497_a, Predicates.equalTo((Object)BlockTallGrass.EnumType.GRASS));
    private static final Predicate<IBlockState> IS_SHORT_GRASS = EntityAIEatBOPGrass.forBoPPlant(BOPPlants.SHORTGRASS);
    private static final Predicate<IBlockState> IS_MEDIUM_GRASS = EntityAIEatBOPGrass.forBoPPlant(BOPPlants.MEDIUMGRASS);
    private static final Predicate<IBlockState> IS_WHEAT_GRASS = EntityAIEatBOPGrass.forBoPPlant(BOPPlants.WHEATGRASS);
    private static final Predicate<IBlockState> IS_DAMP_GRASS = EntityAIEatBOPGrass.forBoPPlant(BOPPlants.DAMPGRASS);
    private EntityLiving sheep;
    private World world;
    int bopEatingGrassTimer;

    public EntityAIEatBOPGrass(EntityLiving entityLiving) {
        super(entityLiving);
        this.sheep = entityLiving;
        this.world = entityLiving.field_70170_p;
        this.func_75248_a(7);
    }

    public boolean func_75250_a() {
        if (this.sheep.func_70681_au().nextInt(this.sheep.func_70631_g_() ? 50 : 1000) != 0) {
            return false;
        }
        BlockPos pos = new BlockPos(this.sheep.field_70165_t, this.sheep.field_70163_u, this.sheep.field_70161_v);
        IBlockState state = this.world.func_180495_p(pos);
        return IS_TALL_GRASS.apply((Object)state) || IS_SHORT_GRASS.apply((Object)state) || IS_MEDIUM_GRASS.apply((Object)state) || IS_WHEAT_GRASS.apply((Object)state) || IS_DAMP_GRASS.apply((Object)state) || this.world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockGrass;
    }

    public void func_75249_e() {
        this.bopEatingGrassTimer = 40;
        this.world.func_72960_a((Entity)this.sheep, (byte)10);
        this.sheep.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.bopEatingGrassTimer = 0;
    }

    public boolean func_75253_b() {
        return this.bopEatingGrassTimer > 0;
    }

    public int func_151499_f() {
        return this.bopEatingGrassTimer;
    }

    public void func_75246_d() {
        this.bopEatingGrassTimer = Math.max(0, this.bopEatingGrassTimer - 1);
        if (this.bopEatingGrassTimer == 4) {
            BlockPos pos = new BlockPos(this.sheep.field_70165_t, this.sheep.field_70163_u, this.sheep.field_70161_v);
            IBlockState state = this.world.func_180495_p(pos);
            if (IS_TALL_GRASS.apply((Object)state) || IS_SHORT_GRASS.apply((Object)state) || IS_MEDIUM_GRASS.apply((Object)state) || IS_WHEAT_GRASS.apply((Object)state) || IS_DAMP_GRASS.apply((Object)state)) {
                if (this.world.func_82736_K().func_82766_b("mobGriefing")) {
                    this.world.func_175655_b(pos, false);
                }
                this.sheep.func_70615_aA();
            } else {
                BlockPos posDown = pos.func_177977_b();
                IBlockState stateDown = this.world.func_180495_p(posDown);
                if (stateDown.func_177230_c() instanceof BlockBOPGrass) {
                    BlockBOPGrass grass = (BlockBOPGrass)stateDown.func_177230_c();
                    Block dirtBlock = BlockBOPGrass.getDirtBlockState(stateDown).func_177230_c();
                    if (dirtBlock instanceof BlockBOPDirt) {
                        if (this.world.func_82736_K().func_82766_b("mobGriefing")) {
                            this.world.func_175718_b(2001, posDown, Block.func_149682_b((Block)Blocks.field_150349_c));
                            this.world.func_180501_a(posDown, BlockBOPGrass.getDirtBlockState(stateDown), 2);
                        }
                    } else if (stateDown.func_177229_b((IProperty)BlockBOPGrass.VARIANT) == BlockBOPGrass.BOPGrassType.DAISY && this.world.func_82736_K().func_82766_b("mobGriefing")) {
                        this.world.func_175718_b(2001, posDown, Block.func_149682_b((Block)Blocks.field_150349_c));
                        this.world.func_180501_a(posDown, Blocks.field_150346_d.func_176223_P(), 2);
                    }
                    this.sheep.func_70615_aA();
                }
            }
        }
    }

    private static BlockStateMatcher forBoPPlant(BOPPlants plant) {
        return BlockStateMatcher.func_177638_a((Block)BOPBlocks.plant_0).func_177637_a((IProperty)BlockBOPPlant.paging.getVariantProperty(BlockBOPPlant.paging.getPageNum((BlockBOPPlant)((Object)plant))), Predicates.equalTo((Object)plant));
    }
}

