/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.world.gen;

import com.zeitheron.hammercore.annotations.MCFBus;
import com.zeitheron.hammercore.world.data.IChunkData;
import com.zeitheron.hammercore.world.data.PerChunkDataManager;
import com.zeitheron.hammercore.world.gen.IWorldGenFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;

@MCFBus
public class WorldRetroGen {
    private static final List<String> mods = new ArrayList<String>();
    private static final Map<String, List<IWorldGenerator>> generators = new HashMap<String, List<IWorldGenerator>>();
    private static final List<IWorldGenFeature> features = new LinkedList<IWorldGenFeature>();
    private static final Set<String> populating = new HashSet<String>();

    public static void addWorldGenerator(IWorldGenerator gen) {
        List<IWorldGenerator> gens;
        String mod = Loader.instance().activeModContainer().getModId();
        if (!mods.contains(mod)) {
            mods.add(mod);
        }
        if ((gens = generators.get(mod)) == null) {
            gens = new ArrayList<IWorldGenerator>();
            generators.put(mod, gens);
        }
        gens.add(gen);
    }

    public static void addWorldFeature(IWorldGenFeature gen) {
        String mod = Loader.instance().activeModContainer().getModId();
        if (!mods.contains(mod)) {
            mods.add(mod);
        }
        if (gen.getRegistryName() == null) {
            gen.setRegistryName(new ResourceLocation(mod, gen.getClass().getName()));
        }
        features.add(gen);
    }

    public static void generateChunk(Chunk c) {
        String key = PerChunkDataManager.build(c);
        if (populating.contains(key)) {
            return;
        }
        populating.add(key);
        Random random = new Random(c.func_177412_p().func_72905_C());
        long xSeed = random.nextLong() >> 3;
        long zSeed = random.nextLong() >> 3;
        long chunkSeed = xSeed * (long)c.field_76635_g + zSeed * (long)c.field_76647_h ^ c.func_177412_p().func_72905_C();
        IChunkGenerator cgen = null;
        IChunkData retrogen = PerChunkDataManager.getData(c);
        for (String mod : mods) {
            List<IWorldGenerator> gens = generators.get(mod);
            if (retrogen.getRetrogenList1().contains(mod)) continue;
            retrogen.getRetrogenList1().add(mod);
            random.setSeed(chunkSeed);
            if (gens == null) continue;
            for (IWorldGenerator igen : gens) {
                if (cgen == null) {
                    cgen = c.func_177412_p().field_73011_w.func_186060_c();
                }
                igen.generate(random, c.field_76635_g, c.field_76647_h, c.func_177412_p(), cgen, c.func_177412_p().func_72863_F());
            }
        }
        random.setSeed(chunkSeed);
        for (IWorldGenFeature feat : features) {
            if (retrogen.getRetrogenList2().contains(feat.getRegistryName().toString())) continue;
            retrogen.getRetrogenList2().add(feat.getRegistryName().toString());
            ChunkPos cp = new ChunkPos(c.field_76635_g, c.field_76647_h);
            for (int i = 0; i < random.nextInt(feat.getMaxChances(c.func_177412_p(), cp, random)); ++i) {
                int genX = random.nextInt(16) + c.field_76635_g * 16;
                int genZ = random.nextInt(16) + c.field_76647_h * 16;
                BlockPos pos = new BlockPos(genX, 0, genZ);
                int minY = feat.getMinY(c.func_177412_p(), pos, random);
                int yDelta = feat.getMaxY(c.func_177412_p(), pos, random) - minY;
                pos = new BlockPos(genX, random.nextInt(yDelta) + minY, genZ);
                feat.generate(c.func_177412_p(), pos, random);
            }
        }
        populating.remove(key);
    }
}

