/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.energy;

import com.zeitheron.hammercore.utils.math.BigMath;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;

public class BigEnergyStorage
implements IEnergyStorage {
    protected BigInteger energy;
    protected BigInteger capacity;
    protected BigInteger maxReceive;
    protected BigInteger maxExtract;

    public BigEnergyStorage(BigInteger capacity) {
        this(capacity, capacity, capacity, BigInteger.ZERO);
    }

    public BigEnergyStorage(BigInteger capacity, BigInteger maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, BigInteger.ZERO);
    }

    public BigEnergyStorage(BigInteger capacity, BigInteger maxReceive, BigInteger maxExtract) {
        this(capacity, maxReceive, maxExtract, BigInteger.ZERO);
    }

    public BigEnergyStorage(BigInteger capacity, BigInteger maxReceive, BigInteger maxExtract, BigInteger energy) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = BigMath.max(BigInteger.ZERO, BigMath.min(capacity, energy));
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        BigInteger energyReceived = BigMath.min(this.capacity.subtract(this.energy), BigMath.min(this.maxReceive, new BigInteger("" + maxReceive)));
        if (!simulate) {
            this.energy = this.energy.add(energyReceived);
        }
        return energyReceived.intValue();
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        BigInteger energyExtracted = BigMath.min(this.energy, BigMath.min(this.maxExtract, new BigInteger(maxExtract + "")));
        if (!simulate) {
            this.energy = this.energy.subtract(energyExtracted);
        }
        return energyExtracted.intValue();
    }

    public int getEnergyStored() {
        return BigMath.trimToInt(this.energy);
    }

    public int getMaxEnergyStored() {
        return BigMath.trimToInt(this.capacity);
    }

    public BigInteger getCapacity() {
        return this.capacity;
    }

    public void setEnergy(BigInteger energy) {
        this.energy = energy;
    }

    public BigInteger getEnergy() {
        return this.energy;
    }

    public boolean canExtract() {
        return BigMath.isAGreaterThenB(this.maxExtract, BigInteger.ZERO, true);
    }

    public boolean canReceive() {
        return BigMath.isAGreaterThenB(this.maxReceive, BigInteger.ZERO, true);
    }

    public BigEnergyStorage setCapacity(BigInteger capacity) {
        this.capacity = capacity;
        this.energy = BigMath.min(this.energy, this.capacity);
        return this;
    }

    public BigEnergyStorage setMaxReceive(BigInteger receive) {
        this.maxReceive = receive;
        return this;
    }

    public BigEnergyStorage setMaxExtract(BigInteger extract) {
        this.maxExtract = extract;
        return this;
    }

    public boolean hasEnergy(Number fe) {
        if (fe instanceof BigDecimal) {
            fe = ((BigDecimal)fe).toBigInteger();
        }
        return BigMath.isAGreaterThenB(this.energy, fe instanceof BigInteger ? (BigInteger)fe : BigInteger.valueOf(fe.longValue()), false);
    }

    public double getFilledProgress() {
        return this.energy.multiply(BigInteger.valueOf(1000000L)).divide(this.capacity).doubleValue() / 1000000.0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("Energy", this.energy.toString(16));
        return nbt;
    }

    public BigEnergyStorage readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("Energy", 8)) {
            this.energy = new BigInteger(nbt.func_74779_i("Energy"), 16);
        }
        return this;
    }
}

