/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.zlib.utils;

import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class Vec2D {
    public static final Vec2D ZERO = new Vec2D(0.0, 0.0);
    public final double x;
    public final double y;

    public static boolean isNearlyEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-4;
    }

    public Vec2D(double xIn, double yIn) {
        if (xIn == -0.0) {
            xIn = 0.0;
        }
        if (yIn == -0.0) {
            yIn = 0.0;
        }
        this.x = xIn;
        this.y = yIn;
    }

    public Vec2D subtractReverse(Vec2D vec) {
        return new Vec2D(vec.x - this.x, vec.y - this.y);
    }

    public Vec2D normalize() {
        double d0 = MathHelper.func_76133_a((double)(this.x * this.x + this.y * this.y));
        return d0 < 1.0E-4 ? ZERO : new Vec2D(this.x / d0, this.y / d0);
    }

    public double dotProduct(Vec2D vec) {
        return this.x * vec.x + this.y * vec.y;
    }

    public Vec2D subtract(Vec2D vec) {
        return this.subtract(vec.x, vec.y);
    }

    public Vec2D subtract(double x, double y) {
        return this.addVector(-x, -y);
    }

    public Vec2D add(Vec2D vec) {
        return this.addVector(vec.x, vec.y);
    }

    public Vec2D addVector(double x, double y) {
        return new Vec2D(this.x + x, this.y + y);
    }

    public double distanceTo(Vec2D vec) {
        double d0 = vec.x - this.x;
        double d1 = vec.y - this.y;
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
    }

    public double distanceTo(double x, double y) {
        double d0 = x - this.x;
        double d1 = y - this.y;
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
    }

    public double squareDistanceTo(Vec2D vec) {
        double d0 = vec.x - this.x;
        double d1 = vec.y - this.y;
        return d0 * d0 + d1 * d1;
    }

    public double squareDistanceTo(double xIn, double yIn) {
        double d0 = xIn - this.x;
        double d1 = yIn - this.y;
        return d0 * d0 + d1 * d1;
    }

    public Vec2D scale(double scale) {
        return new Vec2D(this.x * scale, this.y * scale);
    }

    public double lengthVector() {
        return MathHelper.func_76133_a((double)this.lengthSquared());
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    @Nullable
    public Vec2D getIntermediateWithXValue(Vec3d vec, double x) {
        double d0 = vec.field_72450_a - this.x;
        double d1 = vec.field_72448_b - this.y;
        if (d0 * d0 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (x - this.x) / d0;
        return d3 >= 0.0 && d3 <= 1.0 ? new Vec2D(this.x + d0 * d3, this.y + d1 * d3) : null;
    }

    @Nullable
    public Vec2D getIntermediateWithYValue(Vec3d vec, double y) {
        double d0 = vec.field_72450_a - this.x;
        double d1 = vec.field_72448_b - this.y;
        if (d1 * d1 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (y - this.y) / d1;
        return d3 >= 0.0 && d3 <= 1.0 ? new Vec2D(this.x + d0 * d3, this.y + d1 * d3) : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Vec2D)) {
            return false;
        }
        Vec2D vec3d = (Vec2D)obj;
        if (Double.compare(vec3d.x, this.x) != 0) {
            return false;
        }
        return Double.compare(vec3d.y, this.y) == 0;
    }

    public int hashCode() {
        long j = Double.doubleToLongBits(this.x);
        int i = (int)(j ^ j >>> 32);
        j = Double.doubleToLongBits(this.y);
        i = 31 * i + (int)(j ^ j >>> 32);
        return i;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

