/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils.texture;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.client.utils.texture.BufferedTexture;
import com.zeitheron.hammercore.client.utils.texture.URLImageTexture;
import com.zeitheron.hammercore.client.utils.texture.def.ImagePuller;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;

public class TexLocUploader {
    public static final List<ResourceLocation> cleanup = new ArrayList<ResourceLocation>();
    public static final List<Runnable> cleanCallbacks = new ArrayList<Runnable>();

    public static boolean upload(ResourceLocation rl, BufferedImage bi) {
        return Minecraft.func_71410_x().func_110434_K().func_110579_a(rl, (ITextureObject)new BufferedTexture(bi));
    }

    public static boolean upload(ResourceLocation rl, String url) {
        return Minecraft.func_71410_x().func_110434_K().func_110579_a(rl, (ITextureObject)new URLImageTexture(rl, url));
    }

    public static boolean upload(ResourceLocation rl, BufferedImage bi, boolean blur, boolean clamp) {
        return Minecraft.func_71410_x().func_110434_K().func_110579_a(rl, (ITextureObject)new BufferedTexture(bi, blur, clamp));
    }

    static void cleanupAll() {
        HammerCore.LOG.info("Cleaning " + (cleanup.size() + ImagePuller.GL_IMAGES.size()) + " textures from VRAM");
        ImagePuller.GL_IMAGES.values().forEach(r -> TexLocUploader.deleteGlTexture((ITextureObject)Minecraft.func_71410_x().func_110434_K().field_110585_a.remove(r)));
        cleanup.forEach(r -> TexLocUploader.deleteGlTexture((ITextureObject)Minecraft.func_71410_x().func_110434_K().field_110585_a.remove(r)));
        cleanCallbacks.forEach(r -> r.run());
        cleanup.clear();
        cleanCallbacks.clear();
        HammerCore.LOG.info("Interrupting " + ImagePuller.DWN.size() + " image download threads");
        ImagePuller.DWN.values().forEach(Thread::interrupt);
        ImagePuller.GL_IMAGES.clear();
        ImagePuller.DWN.clear();
    }

    public static void cleanupAfterLogoff(ResourceLocation loca, Runnable ... runnables) {
        cleanup.add(loca);
        cleanCallbacks.addAll(Arrays.asList(runnables));
    }

    public static void deleteGlTexture(ITextureObject tex) {
        if (tex == null) {
            return;
        }
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (tex instanceof AbstractTexture) {
                ((AbstractTexture)tex).func_147631_c();
            } else if (tex.func_110552_b() != -1) {
                TextureUtil.func_147942_a((int)tex.func_110552_b());
            }
        });
    }
}

