/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.IEnergyStorage;

public class TooltipHelper {
    private static final ThreadLocal<List<String>> TOOLTIP = ThreadLocal.withInitial(ArrayList::new);

    public static List<String> emptyTooltipList() {
        TOOLTIP.get().clear();
        return TOOLTIP.get();
    }

    public static List<String> generateEnergy(IEnergyStorage storage) {
        if (storage == null) {
            return TooltipHelper.emptyTooltipList();
        }
        return TooltipHelper.generate("energy", storage.getEnergyStored(), storage.getMaxEnergyStored(), "fe");
    }

    public static List<String> generate(String sub, int val, int max, String def) {
        return TooltipHelper.generateCustom("gui.hammercore." + sub, val, max, def);
    }

    public static List<String> generateCustom(String i18n, int value, int max, String def) {
        Object[] objectArray;
        List<String> tip = TOOLTIP.get();
        tip.clear();
        tip.add(I18n.func_135052_a((String)i18n, (Object[])new Object[0]));
        String string = TextFormatting.GRAY.toString() + "%,d" + (max > 0 ? " / %,d" : "") + " %s";
        if (max > 0) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = value;
            objectArray2[1] = max;
            objectArray = objectArray2;
            objectArray2[2] = I18n.func_135052_a((String)("definition.hammercore:" + def + "." + (GuiScreen.func_146272_n() ? "long" : "short")), (Object[])new Object[0]);
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = value;
            objectArray = objectArray3;
            objectArray3[1] = I18n.func_135052_a((String)("definition.hammercore:" + def + "." + (GuiScreen.func_146272_n() ? "long" : "short")), (Object[])new Object[0]);
        }
        tip.add(String.format(string, objectArray));
        return tip;
    }

    public static String intToString(long num) {
        return String.format("%,d", num);
    }
}

